#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Internet CableMod01.fsh  by Flopine 
//https://www.shadertoy.com/view/3djczc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine
// Thanks to wsmind, leon, XT95, lsdlive, lamogui, Coyhot, Alkama and YX for teaching me
// Thanks LJ for giving me the love of shadercoding :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  https://twitter.com/CookieDemoparty

#define dt (iTime*0.35)
#define hr vec2(1., sqrt(3.))
#define PI 3.141592
#define TAU (2.*PI)

float hash21 (vec2 x)
{return fract(sin(dot(x,vec2(32.5,36.4)))*12458.5);}

float moda (inout vec2 p, float rep)
{
    float per = TAU/rep;
    float a = atan(p.y,p.x);
    float l = length(p);
    float id = floor(a/per);
    a = mod(a,per)-per*0.5;
    p = vec2(cos(a),sin(a))*l;
    if (id > rep*0.5) id = abs(id);
    return id;  
}

float stmin(float a, float b, float k, float n)
{
    float st = k/n;
    float u = b-k;
    return min(min(a,b), 0.5*(u+a+abs(mod(u-a+st,2.*st)-st)));
}

vec4 hgrid (vec2 uv, float detail)
{
    uv *= detail;
    vec2 ga = mod(uv,hr)-hr*0.5;
    vec2 gb = mod(uv-hr*0.5,hr)-hr*0.5;
    vec2 guv = (dot(ga,ga)<dot(gb,gb))? ga:gb;
    vec2 gid = uv - guv;
    guv.y = max(abs(guv.x),dot(abs(guv),normalize(hr)));
    return vec4(guv,gid);
}

mat2 rot( float a)
{return mat2(cos(a),sin(a),-sin(a),cos(a));}


float tore (vec3 p, vec2 t)
{return length(vec2(length(p.xz)-t.x,p.y))-t.y;}

float g1 = 0.;
float lumieres (vec3 p)
{
    p.xz *= rot(iTime);
    float lid = moda(p.xz, 8.);
    p.x -= 5.;
    p.xy *= rot(sin(iTime)*lid*2.);
    moda(p.xy, 5.);
    p.x -= 1.9;
    float d =  length(p)-0.2;
    g1 += 0.01/(0.01+d*d);
    return d;
}

float g2 = 0.;
float pieuvre (vec3 p)
{
    p.xz *= rot(dt);
    p.y += cos(p.z+iTime)*0.6;
    p.x -= 5.5+sin(p.z+iTime)*0.4;
    float od = stmin(length(p)-0.6,dot(p, normalize(sign(p)))-0.5,0.2,5.);
    p.z += 1.8;
    p.xy *= rot(sin(p.z+iTime));
    moda(p.xy, 5.);
    p.x -= 0.4;
    float c = max(length(p.xy)-(0.01+p.z*0.1),abs(p.z)-1.5);
    float d = stmin(c,od, 0.2, 5.);
    g2 += 0.001/(0.001+d*d);
    return d;
}

vec3 new_p;
float pieu;
float SDF (vec3 p)
{
    p.xz *= rot(-dt);
    new_p = p;
    pieu = pieuvre(p);
    return min(min(pieu,lumieres(p)),-tore(p,vec2(5.,2.)));
}

float lignes (vec2 uv, float detail)
{
    uv *= detail;
    uv = fract(uv)-0.5;
    return smoothstep(0.1,0.15, abs(uv.y)) * smoothstep(0.2,0.25, abs(uv.x)-0.1);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = vec2(fragCoord.x / iResolution.x, fragCoord.y / iResolution.y);
    uv -= 0.5;
    uv /= vec2(iResolution.y / iResolution.x, 1);

    uv.x = mix(abs(uv.x)-0.55,uv.x, clamp(floor(sin(iTime*PI/4.))+1.,0.,1.));

    float dither = hash21(uv);

    vec3 ro = vec3(1.,0.0,-6.),
        p=ro,
        rd = normalize(vec3(uv+vec2(0.9,-0.1),1.2)),
        col = vec3(0.);

    float shad,d=0.;
    for(float i=0.; i<64.; i++)
    {
        d = SDF(p);
        if (d<0.001)
        {
            shad = i/64.;
            break;
        }
        d *= 0.9+dither*0.1;
        p +=d*rd;
    }
    
    
    float majorAngle = atan(new_p.z,new_p.x);
    float minorAngle = atan(new_p.y, length(new_p.xz)-5.);
    vec2 tuv = vec2(majorAngle*PI,minorAngle);
    vec4 hg = hgrid(tuv,3.);
    
    float mask = smoothstep(0.1,0.12,abs((sin(length(vec2(minorAngle))-iTime))-1.));
    vec3 hcol = vec3(smoothstep(0.3,0.43+sin(length(hg.zw)-iTime),hg.y));
    vec3 lcol =  vec3(0.,0.8,0.)*(1.-lignes(vec2(majorAngle, minorAngle), 5.));
    
    if (d == pieu) col = vec3(shad);
    else col = mix(lcol, hcol, mask);
    
    col *= vec3(1.-shad); 
    col += g1*vec3(0.1,0.8,0.3);
    col += g2*vec3(0.7,0.1,0.2);

    fragColor = vec4(col,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

